/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.item;

import com.simibubi.create.foundation.item.IItemHandlerModifiableIntermediate;
import com.simibubi.create.foundation.tileEntity.SyncedTileEntity;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class SmartInventory
extends RecipeWrapper
implements IItemHandlerModifiableIntermediate,
INBTSerializable<CompoundTag> {
    protected boolean extractionAllowed;
    protected boolean insertionAllowed;
    protected boolean stackNonStackables;
    protected SyncedStackHandler wrapped;
    protected int stackSize;

    public SmartInventory(int slots, SyncedTileEntity te) {
        this(slots, te, 64, false);
    }

    public SmartInventory(int slots, SyncedTileEntity te, int stackSize, boolean stackNonStackables) {
        super((IItemHandlerModifiable)new SyncedStackHandler(slots, te, stackNonStackables, stackSize));
        this.stackNonStackables = stackNonStackables;
        this.insertionAllowed = true;
        this.extractionAllowed = true;
        this.stackSize = stackSize;
        this.wrapped = (SyncedStackHandler)this.inv;
    }

    public SmartInventory withMaxStackSize(int maxStackSize) {
        this.stackSize = maxStackSize;
        this.wrapped.stackSize = maxStackSize;
        return this;
    }

    public SmartInventory whenContentsChanged(Consumer<Integer> updateCallback) {
        ((SyncedStackHandler)this.inv).whenContentsChange(updateCallback);
        return this;
    }

    public SmartInventory allowInsertion() {
        this.insertionAllowed = true;
        return this;
    }

    public SmartInventory allowExtraction() {
        this.extractionAllowed = true;
        return this;
    }

    public SmartInventory forbidInsertion() {
        this.insertionAllowed = false;
        return this;
    }

    public SmartInventory forbidExtraction() {
        this.extractionAllowed = false;
        return this;
    }

    public int getSlots() {
        return this.inv.getSlots();
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (!this.insertionAllowed) {
            return stack;
        }
        return this.inv.insertItem(slot, stack, simulate);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack extractItem;
        if (!this.extractionAllowed) {
            return ItemStack.f_41583_;
        }
        if (this.stackNonStackables && !(extractItem = this.inv.extractItem(slot, amount, true)).m_41619_() && extractItem.m_41741_() < extractItem.m_41613_()) {
            amount = extractItem.m_41741_();
        }
        return this.inv.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return Math.min(this.inv.getSlotLimit(slot), this.stackSize);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.inv.isItemValid(slot, stack);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.inv.setStackInSlot(slot, stack);
    }

    public ItemStack m_8020_(int slot) {
        return super.m_8020_(slot);
    }

    public int getStackLimit(int slot, @Nonnull ItemStack stack) {
        return Math.min(this.getSlotLimit(slot), stack.m_41741_());
    }

    public CompoundTag serializeNBT() {
        return this.getInv().serializeNBT();
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.getInv().deserializeNBT(nbt);
    }

    private SyncedStackHandler getInv() {
        return (SyncedStackHandler)this.inv;
    }

    @Override
    public ItemStack getStackInSlotIntermediate(int slot) {
        return this.m_8020_(slot);
    }

    private static class SyncedStackHandler
    extends ItemStackHandler {
        private SyncedTileEntity te;
        private boolean stackNonStackables;
        private int stackSize;
        private Consumer<Integer> updateCallback;

        public SyncedStackHandler(int slots, SyncedTileEntity te, boolean stackNonStackables, int stackSize) {
            super(slots);
            this.te = te;
            this.stackNonStackables = stackNonStackables;
            this.stackSize = stackSize;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (this.updateCallback != null) {
                this.updateCallback.accept(slot);
            }
            this.te.notifyUpdate();
        }

        public int getSlotLimit(int slot) {
            return Math.min(this.stackNonStackables ? 64 : super.getSlotLimit(slot), this.stackSize);
        }

        public void whenContentsChange(Consumer<Integer> updateCallback) {
            this.updateCallback = updateCallback;
        }
    }
}

